/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import processing.core.PException;
import processing.core.PMIDlet;

public class PRequest
extends InputStream
implements Runnable {
    public static final int STATE_OPENED = 0;
    public static final int STATE_CONNECTED = 1;
    public static final int STATE_FETCHING = 2;
    public static final int STATE_DONE = 3;
    public static final int STATE_ERROR = 4;
    public static final int STATE_CLOSED = 5;
    public static final int EVENT_CONNECTED = 0;
    public static final int EVENT_DONE = 1;
    public static final int EVENT_ERROR = 2;
    protected PMIDlet midlet;
    protected String url;
    protected String contentType;
    protected byte[] bytes;
    protected HttpConnection con;
    protected InputStream is;
    public int state;

    public PRequest(PMIDlet pMIDlet, String string, String string2, byte[] byArray) {
        this.midlet = pMIDlet;
        this.url = string;
        this.contentType = string2;
        this.bytes = byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block38: {
            OutputStream outputStream = null;
            try {
                if (this.is == null) {
                    this.con = (HttpConnection)Connector.open((String)this.url);
                    if (this.contentType != null) {
                        this.con.setRequestMethod("POST");
                        this.con.setRequestProperty("Content-Type", this.contentType);
                    } else {
                        this.con.setRequestMethod("GET");
                    }
                    this.con.setRequestProperty("Connection", "close");
                    if (this.bytes != null) {
                        outputStream = this.con.openOutputStream();
                        outputStream.write(this.bytes);
                        this.bytes = null;
                    }
                    this.is = this.con.openInputStream();
                    boolean bl = false;
                    PRequest pRequest = this;
                    synchronized (pRequest) {
                        if (this.state == 0) {
                            this.state = 1;
                            bl = true;
                        }
                    }
                    if (bl) {
                        this.midlet.enqueueLibraryEvent(this, 0, null);
                    }
                    break block38;
                }
                Closeable closeable = this;
                synchronized (closeable) {
                    if (this.state != 1) {
                        throw new Exception("Not connected.");
                    }
                    this.state = 2;
                }
                closeable = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                int n = this.is.read(byArray);
                while (n >= 0) {
                    ((ByteArrayOutputStream)closeable).write(byArray, 0, n);
                    n = this.is.read(byArray);
                }
                byArray = null;
                byArray = ((ByteArrayOutputStream)closeable).toByteArray();
                boolean bl = false;
                PRequest pRequest = this;
                synchronized (pRequest) {
                    if (this.state == 2) {
                        this.state = 3;
                        bl = true;
                    }
                }
                if (bl) {
                    this.midlet.enqueueLibraryEvent(this, 1, byArray);
                }
            }
            catch (Exception exception) {
                boolean bl = false;
                PRequest pRequest = this;
                synchronized (pRequest) {
                    if (this.state == 1 || this.state == 2) {
                        bl = true;
                    }
                }
                this.close();
                if (!bl) break block38;
                pRequest = this;
                synchronized (pRequest) {
                    this.state = 4;
                }
                this.midlet.enqueueLibraryEvent(this, 2, exception.getMessage());
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (Exception exception) {}
                    outputStream = null;
                }
            }
        }
    }

    public int read() {
        try {
            return this.is.read();
        }
        catch (IOException iOException) {
            throw new PException(iOException);
        }
    }

    public char readChar() {
        return (char)this.read();
    }

    public void readBytes() {
        Thread thread = new Thread(this);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        PRequest pRequest = this;
        synchronized (pRequest) {
            this.state = 5;
        }
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.is = null;
        }
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.con = null;
        }
    }
}

